import mongoose from "mongoose";

const serviceSchema = new mongoose.Schema(
  {
    serviceName: {
      type: String,
      required: [true, "Service is required"],
      trim: true,
      max_length: [25, "Service cannot exceed 25 characters"],
    },
    name: {
      type: String,
      required: [true, "Name is required"],
      trim: true,
      max_length: [25, "Name cannot exceed 25 characters"],
    },
    email: {
      type: String,
      required: [true, "Email is required"],
      trim: true,
      lowercase: true,
      match: [
        /^\w+([.-]?\w+)*@\w+([.-]?\w+)*(\.\w{2,3})+$/,
        "Please enter a valid email",
      ],
    },
    phone: {
        type: String,
        required: [true, "Phone is required"],
        trim: true,
        match: [
            /^\+?[1-9]\d{1,14}$/,
            "Please enter a valid phone number",
        ],
    },
    message: {
      type: String,
      required: [true, "Service message is required"],
      max_length: [1000, "message cannot exceed 1000 characters"],
    },

  },
  {
    timestamps: true,
    toJSON: {
      transform: function (doc, ret) {
        ret.id = ret._id;
        delete ret._id;
        delete ret.__v;
        return ret;
      },
    },
  }
);

export default mongoose.models.Service ||
  mongoose.model("Service", serviceSchema);
