import React from "react";
import "./WhyChooseUs.css";
import Image from "next/image";
import WhyChooseImg from "../../../public/images/wh-img-1.webp";
import award1 from "../../../public/images/award-1.webp";
import award2 from "../../../public/images/award-2.webp";
import award3 from "../../../public/images/award-3.webp";
import award4 from "../../../public/images/award-4.webp";
import calculation from "../../../public/images/calculation.svg";
import startup from "../../../public/images/startup.svg";
import dataManagement from "../../../public/images/data-management.svg";
import Link from "next/link";
import { IoChevronForwardOutline } from "react-icons/io5";

const WhyChooseUs = () => {
  return (
    <section className="why-choose-us-sec">
      <div className="container">
        <div className="row mb-5 align-items-center">
          <div className="col-lg-6">
            <div className="why-choose-usImage">
              <Image
                src={WhyChooseImg}
                width={700}
                height={812}
                alt="WhyChooseImg"
              />
            </div>
          </div>
          <div className="col-lg-6">
            <div className="why-choose-us-content">
              <span>Why Choose Us</span>
              <h2>Mission & Vision</h2>

              <p className="para">
                Our mission is simple: empower individuals and families to take
                control of their credit. We believe that access to fair,
                accurate credit reporting and responsible financial habits opens
                doors-renting a home, buying a car, qualifying for better
                interest rates, and building long-term stability.
              </p>
              <p className="para">
                We envision a community where credit is no longer a barrier to
                opportunity, and where clients feel confident about the steps
                they're taking toward a healthier financial life.
              </p>
            </div>

            <div className="why-choose-us-content2">
              <h3>We are award winning company</h3>

              <div className="award-images">
                <Image src={award1} alt="award1" />
                <Image src={award2} alt="award2" />
                <Image src={award3} alt="award3" />
                <Image src={award4} alt="award4" />
              </div>

              <div className="d-flex align-items-center">
                <Link href={"/services"}>
                  View Our Services <IoChevronForwardOutline color="#7b011d" />
                </Link>
              </div>
            </div>
          </div>
        </div>

        <div className="row">
          <div className="col-lg-4">
            <div className="why-choose-box">
              {/* <div className="why-choose-box-image">
                <Image src={calculation} alt="calculation" />
              </div> */}
              <div className="why-choose-box-content">
                <h3>Integrity</h3>
                <p className="para">
                  Transparent, Honest Gyudance – No false Promises
                </p>
              </div>
            </div>
          </div>
          <div className="col-lg-4">
            <div className="why-choose-box">
              {/* <div className="why-choose-box-image">
                <Image src={startup} alt="startup" />
              </div> */}
              <div className="why-choose-box-content">
                <h3>Compliance</h3>
                <p className="para">
                  We operate under the Credit Repair Organizations Act (CROA)
                  and respect the Fair Credit Reporting Act (FCRA).
                </p>
              </div>
            </div>
          </div>
          <div className="col-lg-4">
            <div className="why-choose-box">
              {/* <div className="why-choose-box-image">
                <Image src={dataManagement} alt="dataManagement" />
              </div> */}
              <div className="why-choose-box-content">
                <h3>Security</h3>
                <p className="para">
                  Safeguarding your data with strong controls and
                  confidentiality.
                </p>
              </div>
            </div>
          </div>
          <div className="col-lg-4">
            <div className="why-choose-box">
              {/* <div className="why-choose-box-image">
                <Image src={dataManagement} alt="dataManagement" />
              </div> */}
              <div className="why-choose-box-content">
                <h3>Education</h3>
                <p className="para">
                  We teach strategies that help you maintain results.
                </p>
              </div>
            </div>
          </div>
          <div className="col-lg-4">
            <div className="why-choose-box">
              {/* <div className="why-choose-box-image">
                <Image src={dataManagement} alt="dataManagement" />
              </div> */}
              <div className="why-choose-box-content">
                <h3>Service</h3>
                <p className="para">Real support from real people who care.</p>
              </div>
            </div>
          </div>
        </div>

        <p className="mt-5 disclaimer-text">
          <span style={{ fontWeight: "600" }}>Note: </span> Results vary by
          individual. No company can promise a specific score increase. We are
          not a law firm and do not provide legal or tax advice.
        </p>
        <div className="disclaimer-text2 mt-5">
          <h1>Leadership</h1>
          <p className="disclaimer-text">
            <span style={{ fontWeight: "600" }}>Douglas G. Abbott </span>{" "}
            Founder & Author. Douglas leads strategy and client education at
            Credit Services USA, authoring guides and to-do workbooks that
            simplify the credit improvement journey.
          </p>
        </div>
      </div>
    </section>
  );
};

export default WhyChooseUs;
