// components/TermsContent/TermsContent.js
import React from "react";
import "./TermsContent.css";

const TermsContent = () => {
  return (
    <section className="terms-content">
      <div className="container">
        <div className="row">
          <div className="col-lg-12">
            <div className="terms-intro">
              <p>
                Welcome to Credit Services USA. By using our website and services, 
                you agree to the following Terms of Service. Please read them carefully 
                before engaging with our company.
              </p>
            </div>
            
            <div className="terms-section">
              <h2>1. Acceptance of Terms</h2>
              <p>
                By accessing or using our website, you confirm that you are at least 
                18 years of age and agree to comply with these Terms. If you do not 
                agree, please do not use our site or services.
              </p>
            </div>
            
            <div className="terms-section">
              <h2>2. Services Provided</h2>
              <p>
                Credit Services USA offers credit repair, credit education, and related 
                financial services designed to help clients improve their credit standing. 
                Results vary by individual and are not guaranteed. We do not offer legal 
                or tax advice.
              </p>
            </div>
            
            <div className="terms-section">
              <h2>3. Client Responsibilities</h2>
              <ul>
                <li>Provide accurate, current, and complete information.</li>
                <li>Review all service agreements before signing.</li>
                <li>Maintain regular communication with our team during your credit service period.</li>
              </ul>
              <p>
                Failure to provide accurate information may delay or limit service results.
              </p>
            </div>
            
            <div className="terms-section">
              <h2>4. Fees and Billing</h2>
              <p>
                All fees and charges are clearly outlined in your Service Agreement or 
                Fee Schedule. Payments are due according to your plan and can be canceled 
                per the cancellation policy stated in your agreement.
              </p>
            </div>        
          </div>
        </div>
      </div>
    </section>
  );
};

export default TermsContent;