"use client";
import React from "react";
import "./SuccessStory.css";
import Image from "next/image";
import { Swiper, SwiperSlide } from "swiper/react";

import "swiper/css";
import "swiper/css/free-mode";
import "swiper/css/pagination";
import { Autoplay, FreeMode, Pagination } from "swiper/modules";

import project1 from "../../../public/images/project-1.webp";
import project2 from "../../../public/images/project-2.webp";
import project3 from "../../../public/images/project-3.webp";
import project4 from "../../../public/images/project-4.webp";
import project5 from "../../../public/images/project-5.webp";
import Link from "next/link";
import { FaArrowRightLong } from "react-icons/fa6";

const SuccessStory = () => {
  return (
    <section className="success-story-sec">
      <div className="container-fluid">
        <div className="row">
          <div className="col-lg-12">
            <div className="success-story-content">
              <h3>Success Stories</h3>
              <h2 className="same-heading">
                <span>Explore</span> Our Customer <span>Success Stories</span>
              </h2>
            </div>
          </div>
          <div className="col-lg-12">
            <div className="stories-slider-sec">
              <Swiper
                slidesPerView={3}
                spaceBetween={30}
                freeMode={true}
                pagination={{
                  clickable: true,
                }}
                autoplay={{
                  delay: 2500,
                  disableOnInteraction: false,
                }}
                loop={true}
                modules={[FreeMode, Pagination, Autoplay]}
                className="mySwiper"
              >
                <SwiperSlide>
                  <div className="stories-slide-box">
                    <div className="stories-slide-box-content">
                      <span>01</span>
                      <p>Best Mortgage Rates Guaranteed</p>
                    </div>
                  </div>
                </SwiperSlide>
                <SwiperSlide>
                  <div className="stories-slide-box stories-slide-box2">
                    <div className="stories-slide-box-content">
                      <span>02</span>
                      <p>Successful Digital for a Financial Institution</p>
                    </div>
                  </div>
                </SwiperSlide>
                <SwiperSlide>
                  <div className="stories-slide-box stories-slide-box3">
                    <div className="stories-slide-box-content">
                      <span>03</span>
                      <p>A Case Study on Market Expansion Submit</p>
                    </div>
                  </div>
                </SwiperSlide>
                <SwiperSlide>
                  <div className="stories-slide-box stories-slide-box4">
                    <div className="stories-slide-box-content">
                      <span>04</span>
                      <p>Digital Production Unique For A Company</p>
                    </div>
                  </div>
                </SwiperSlide>
                <SwiperSlide>
                  <div className="stories-slide-box stories-slide-box5">
                    <div className="stories-slide-box-content">
                      <span>05</span>
                      <p>Best Mortgage Rates Guaranteed</p>
                    </div>
                  </div>
                </SwiperSlide>
              </Swiper>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default SuccessStory;
