"use client";
import React, { useState } from "react";

const ServiceFormModal = ({ show, handleClose, selectedService }) => {
  const [formData, setFormData] = useState({
    serviceName: selectedService,
    name: "",
    email: "",
    phone: "",
    message: "",
  });
  const [loading, setLoading] = useState(false);
  const [responseMsg, setResponseMsg] = useState(null);

  const handleChange = (e) => {
    setFormData({ ...formData, [e.target.name]: e.target.value });
  };

  const handleSubmit = async (e) => {
    formData.serviceName = selectedService;
    e.preventDefault();
    setLoading(true);
    setResponseMsg(null);

    try {
      const res = await fetch("/api/service", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify(formData),
      });
      const data = await res.json();

      if (data.success) {
        setResponseMsg({ type: "success", text: data.message });
        setFormData({
          serviceName: selectedService,
          name: "",
          email: "",
          phone: "",
          message: "",
        });
      } else {
        setResponseMsg({
          type: "danger",
          text: data.error || "Submission failed",
        });
      }
    } catch (err) {
      setResponseMsg({
        type: "danger",
        text: "Server error. Try again later.",
      });
    } finally {
      setLoading(false);
    }
  };

  return (
    <div
      className={`modal fade ${show ? "show d-block" : ""}`}
      tabIndex="-1"
      style={{ background: show ? "rgba(0,0,0,0.5)" : "transparent" }}
    >
      <div className="modal-dialog modal-dialog-centered">
        <div className="modal-content">
          {/* Header */}
          <div className="modal-header">
            <h5 className="modal-title">Request {selectedService}</h5>
            <button
              type="button"
              className="btn-close"
              onClick={handleClose}
            ></button>
          </div>

          {/* Body */}
          <div className="modal-body">
            {responseMsg && (
              <div className={`alert alert-${responseMsg.type}`}>
                {responseMsg.text}
              </div>
            )}

            <form onSubmit={handleSubmit}>
              <input
                type="hidden"
                name="serviceName"
                value={formData.serviceName}
              />

              <div className="mb-3">
                <label className="form-label">Name</label>
                <input
                  type="text"
                  name="name"
                  value={formData.name}
                  onChange={handleChange}
                  className="form-control"
                  required
                />
              </div>

              <div className="mb-3">
                <label className="form-label">Email</label>
                <input
                  type="email"
                  name="email"
                  value={formData.email}
                  onChange={handleChange}
                  className="form-control"
                  required
                />
              </div>

              <div className="mb-3">
                <label className="form-label">Phone</label>
                <input
                  type="tel"
                  name="phone"
                  value={formData.phone}
                  onChange={handleChange}
                  className="form-control"
                  required
                />
              </div>

              <div className="mb-3">
                <label className="form-label">Message</label>
                <textarea
                  name="message"
                  value={formData.message}
                  onChange={handleChange}
                  rows="3"
                  className="form-control"
                  required
                  style={{ resize: "none" }}
                ></textarea>
              </div>

              <button
                type="submit"
                className="btn btn-primary"
                disabled={loading}
                style={{
                  backgroundColor: "#7b011d",
                  border: "none",
                  outline: "none",
                }}
              >
                {loading ? "Submitting..." : "Submit"}
              </button>
            </form>
          </div>
        </div>
      </div>
    </div>
  );
};

export default ServiceFormModal;
