"use client";
import React, { useState } from "react";
import "./HomePageFaqSec.css";

const HomePageFaqSec = () => {
  const [activeItem, setActiveItem] = useState(null);

  const faqData = [
    {
      id: 1,
      question: "How long does it take to improve my credit score?",
      answer:
        "The time it takes to improve your credit score varies depending on your specific situation. Generally, you may start seeing improvements within 30-60 days, but significant changes can take 3-6 months or longer. Factors like the severity of negative items, your payment history, and the actions taken all influence the timeline.",
    },
    {
      id: 2,
      question: "Can you remove all negative items from my credit report?",
      answer:
        "We focus on identifying and disputing inaccurate, unverifiable, or outdated items. While no company can guarantee removal of all negative marks, we ensure every correction is handled ethically and in compliance with federal laws.",
    },
    {
      id: 3,
      question: "Will my information remain confidential?",
      answer:
        "Yes, absolutely. We take your privacy and data security very seriously. All your personal and financial information is protected with industry-standard encryption and security measures. We never share your information with third parties without your explicit consent, and we comply with all applicable privacy laws and regulations.",
    },
    {
      id: 4,
      question: "Do you offer free consultations?",
      answer:
        "Yes, we offer free initial consultations to review your credit situation and discuss how we can help. During this consultation, we'll analyze your credit report, identify potential issues, and explain our process. There's no obligation, and you'll get valuable insights about your credit even if you decide not to proceed with our services.",
    },
    {
      id: 5,
      question: "How do I schedule an appointment?",
      answer:
        "Scheduling an appointment is easy! You can call our office during business hours, use our online booking system on our website, or send us an email with your preferred times. We offer flexible scheduling options including phone consultations, video calls, and in-person meetings to accommodate your schedule.",
    },
    {
      id: 6,
      question: "Is credit repair legal?",
      answer:
        "Yes, credit repair is completely legal. The Fair Credit Reporting Act (FCRA) gives you the right to dispute inaccurate, incomplete, or unverifiable information on your credit reports. Credit repair companies help you exercise these legal rights more effectively. We operate in full compliance with federal and state laws governing credit repair services.",
    },
  ];

  const toggleItem = (id) => {
    setActiveItem(activeItem === id ? null : id);
  };
  return (
    <section className="faq-sec">
      <div className="container">
        <div className="row">
          <div className="col-lg-12">
            <div className="faq-sec-content">
              <h2 className="same-heading">
                Frequently Asked <span>Questions</span>
              </h2>
              <p className="para">Reach Out to Us for Further Assistance.</p>
            </div>
          </div>

          <div className="col-lg-12">
            <div
              className="accordion accordion-flush"
              id="accordionFlushExample"
            >
              <div className="accordion-item">
                <h2 className="accordion-header" id="flush-headingOne">
                  <button
                    className="accordion-button collapsed"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#flush-collapseOne"
                    aria-expanded="false"
                    aria-controls="flush-collapseOne"
                  >
                    How long does it take to improve my credit score?
                  </button>
                </h2>
                <div
                  id="flush-collapseOne"
                  className="accordion-collapse collapse"
                  aria-labelledby="flush-headingOne"
                  data-bs-parent="#accordionFlushExample"
                >
                  <div className="accordion-body">
                    The time it takes to improve your credit score varies
                    depending on your specific situation. Generally, you may
                    start seeing improvements within 30-60 days, but significant
                    changes can take 3-6 months or longer. Factors like the
                    severity of negative items, your payment history, and the
                    actions taken all influence the timeline.
                  </div>
                </div>
              </div>
              <div className="accordion-item">
                <h2 className="accordion-header" id="flush-headingTwo">
                  <button
                    className="accordion-button collapsed"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#flush-collapseTwo"
                    aria-expanded="false"
                    aria-controls="flush-collapseTwo"
                  >
                    Can you remove all negative items from my credit report?
                  </button>
                </h2>
                <div
                  id="flush-collapseTwo"
                  className="accordion-collapse collapse"
                  aria-labelledby="flush-headingTwo"
                  data-bs-parent="#accordionFlushExample"
                >
                  <div className="accordion-body">
                    We focus on identifying and disputing inaccurate,
                    unverifiable, or outdated items. While no company can
                    guarantee removal of all negative marks, we ensure every
                    correction is handled ethically and in compliance with
                    federal laws.
                  </div>
                </div>
              </div>
              <div className="accordion-item">
                <h2 className="accordion-header" id="flush-headingThree">
                  <button
                    className="accordion-button collapsed"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#flush-collapseThree"
                    aria-expanded="false"
                    aria-controls="flush-collapseThree"
                  >
                    Will my information remain confidential?
                  </button>
                </h2>
                <div
                  id="flush-collapseThree"
                  className="accordion-collapse collapse"
                  aria-labelledby="flush-headingThree"
                  data-bs-parent="#accordionFlushExample"
                >
                  <div className="accordion-body">
                    Yes, absolutely. We take your privacy and data security very
                    seriously. All your personal and financial information is
                    protected with industry-standard encryption and security
                    measures. We never share your information with third parties
                    without your explicit consent, and we comply with all
                    applicable privacy laws and regulations.
                  </div>
                </div>
              </div>

              <div className="accordion-item">
                <h2 className="accordion-header" id="flush-headingFour">
                  <button
                    className="accordion-button collapsed"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#flush-collapseFour"
                    aria-expanded="false"
                    aria-controls="flush-collapseFour"
                  >
                    Do you offer free consultations?
                  </button>
                </h2>
                <div
                  id="flush-collapseFour"
                  className="accordion-collapse collapse"
                  aria-labelledby="flush-headingFour"
                  data-bs-parent="#accordionFlushExample"
                >
                  <div className="accordion-body">
                    Yes, we offer free initial consultations to review your
                    credit situation and discuss how we can help. During this
                    consultation, we'll analyze your credit report, identify
                    potential issues, and explain our process. There's no
                    obligation, and you'll get valuable insights about your
                    credit even if you decide not to proceed with our services.
                  </div>
                </div>
              </div>

              <div className="accordion-item">
                <h2 className="accordion-header" id="flush-headingFive">
                  <button
                    className="accordion-button collapsed"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#flush-collapseFive"
                    aria-expanded="false"
                    aria-controls="flush-collapseFive"
                  >
                    How do I schedule an appointment?
                  </button>
                </h2>
                <div
                  id="flush-collapseFive"
                  className="accordion-collapse collapse"
                  aria-labelledby="flush-headingFive"
                  data-bs-parent="#accordionFlushExample"
                >
                  <div className="accordion-body">
                    Scheduling an appointment is easy! You can call our office
                    during business hours, use our online booking system on our
                    website, or send us an email with your preferred times. We
                    offer flexible scheduling options including phone
                    consultations, video calls, and in-person meetings to
                    accommodate your schedule.
                  </div>
                </div>
              </div>
              <div className="accordion-item">
                <h2 className="accordion-header" id="flush-headingSix">
                  <button
                    className="accordion-button collapsed"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#flush-collapseSix"
                    aria-expanded="false"
                    aria-controls="flush-collapseSix"
                  >
                    Is credit repair legal?
                  </button>
                </h2>
                <div
                  id="flush-collapseSix"
                  className="accordion-collapse collapse"
                  aria-labelledby="flush-headingSix"
                  data-bs-parent="#accordionFlushExample"
                >
                  <div className="accordion-body">
                    Yes, credit repair is completely legal. The Fair Credit
                    Reporting Act (FCRA) gives you the right to dispute
                    inaccurate, incomplete, or unverifiable information on your
                    credit reports. Credit repair companies help you exercise
                    these legal rights more effectively. We operate in full
                    compliance with federal and state laws governing credit
                    repair services.
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default HomePageFaqSec;
