import React from "react";
import "./HomePageCore.css";
import Link from "next/link";
import { GoArrowRight } from "react-icons/go";
import Image from "next/image";
import core1 from "../../../public/images/core1.png";
import core2 from "../../../public/images/core2.png";
import core3 from "../../../public/images/core3.png";
import core4 from "../../../public/images/core4.png";
import core5 from "../../../public/images/core5.png";
import core6 from "../../../public/images/core6.png";

const HomePageCore = () => {
  return (
    <section className="HomePageCore">
      <div className="container">
        <div className="row">
          <div className="col-lg-12">
            <div className="HomePageCore-content">
              <h2 className="same-heading">
                <span>Our</span> Core Values
              </h2>
              <p className="para">
                At Credit Services LLC, integrity, transparency, and commitment
                guide everything we do. We empower our clients with trust-driven
                financial solutions designed to build lasting success and
                financial confidence.
              </p>
            </div>
          </div>
        </div>

        <div className="row">
          <div className="col-lg-6">
            <div className="core-values-main">
              <Link href={"/services"}>
                <div className="core-values-content-main">
                  <div className="core-values-content">
                    <div className="core-values-image">
                      <Image src={core1} width={55} height={55} alt="core1" />
                    </div>
                    <div className="core-values-image-content">
                      <h3>Integrity</h3>
                      <p className="para">
                        We operate with complete transparency, honesty, and
                        compliance to ensure ethical credit solutions.
                      </p>
                    </div>
                  </div>
                  <GoArrowRight color="#7b011d" size={22} />
                </div>
              </Link>
            </div>
          </div>
          <div className="col-lg-6">
            <div className="core-values-main">
              <Link href={"/services"}>
                <div className="core-values-content-main">
                  <div className="core-values-content">
                    <div className="core-values-image">
                      <Image src={core2} width={55} height={55} alt="core2" />
                    </div>
                    <div className="core-values-image-content">
                      <h3>Commitment</h3>
                      <p className="para">
                        Your success is our priority—we are dedicated to guiding
                        you every step of the way.
                      </p>
                    </div>
                  </div>
                  <GoArrowRight color="#7b011d" size={22} />
                </div>
              </Link>
            </div>
          </div>
          <div className="col-lg-6">
            <div className="core-values-main">
              <Link href={"/services"}>
                <div className="core-values-content-main">
                  <div className="core-values-content">
                    <div className="core-values-image">
                      <Image src={core3} width={55} height={55} alt="core3" />
                    </div>
                    <div className="core-values-image-content">
                      <h3>Excellence</h3>
                      <p className="para">
                        We strive for the highest standards in service,
                        delivering proven results and measurable improvements.
                      </p>
                    </div>
                  </div>
                  <GoArrowRight color="#7b011d" size={22} />
                </div>
              </Link>
            </div>
          </div>
          <div className="col-lg-6">
            <div className="core-values-main">
              <Link href={"/services"}>
                <div className="core-values-content-main">
                  <div className="core-values-content">
                    <div className="core-values-image">
                      <Image src={core4} width={55} height={55} alt="core4" />
                    </div>
                    <div className="core-values-image-content">
                      <h3>Empowerment</h3>
                      <p className="para">
                        We provide clients with the knowledge and tools needed
                        to make smarter financial decisions.
                      </p>
                    </div>
                  </div>
                  <GoArrowRight color="#7b011d" size={22} />
                </div>
              </Link>
            </div>
          </div>
          <div className="col-lg-6">
            <div className="core-values-main">
              <Link href={"/services"}>
                <div className="core-values-content-main">
                  <div className="core-values-content">
                    <div className="core-values-image">
                      <Image src={core5} width={55} height={55} alt="core5" />
                    </div>
                    <div className="core-values-image-content">
                      <h3>Confidentiality</h3>
                      <p className="para">
                        Your privacy and trust are paramount. We safeguard your
                        information with the utmost care.
                      </p>
                    </div>
                  </div>
                  <GoArrowRight color="#7b011d" size={22} />
                </div>
              </Link>
            </div>
          </div>
          <div className="col-lg-6">
            <div className="core-values-main">
              <Link href={"/services"}>
                <div className="core-values-content-main">
                  <div className="core-values-content">
                    <div className="core-values-image">
                      <Image src={core6} width={55} height={55} alt="core6" />
                    </div>
                    <div className="core-values-image-content">
                      <h3>Customer-Centric Approach</h3>
                      <p className="para">
                        We put our clients first, tailoring every solution to
                        meet their unique credit and financial needs.
                      </p>
                    </div>
                  </div>
                  <GoArrowRight color="#7b011d" size={22} />
                </div>
              </Link>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default HomePageCore;
