"use client";
import React, { useState } from "react";
import "./HomePageContactSec.css";
import Link from "next/link";

import { IoMdMail } from "react-icons/io";
import { FaFacebookF, FaInstagram, FaPhoneAlt } from "react-icons/fa";
import { IoLocationSharp } from "react-icons/io5";
import { FaXTwitter } from "react-icons/fa6";
import { GoArrowUpRight } from "react-icons/go";

const HomePageContactSec = () => {
  const [formData, setFormData] = useState({
    name: "",
    email: "",
    phone: "",
    message: "",
  });

  const [loading, setLoading] = useState(false);
  const [feedback, setFeedback] = useState(null);

  const handleChange = (e) => {
    const { name, value, type, checked } = e.target;
    setFormData({
      ...formData,
      [name]: value,
    });
  };

  const handleSubmit = async (e) => {
    e.preventDefault();

    setLoading(true);
    setFeedback(null);

    try {
      const res = await fetch("/api/contact-us", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify(formData),
      });

      const data = await res.json();

      if (res.ok) {
        setFeedback({ success: true, message: data.message });
        setFormData({
          name: "",
          email: "",
          phone: "",
          message: "",
        });
      } else {
        setFeedback({
          success: false,
          message: data.error || "Something went wrong",
        });
      }
    } catch (err) {
      setFeedback({
        success: false,
        message: "Failed to submit. Try again later.",
      });
    } finally {
      setLoading(false);
    }
  };

  return (
    <section className="contact-sec">
      <div className="container">
        <div className="row">
          <div className="col-lg-12">
            <div className="contact-sec-content">
              <div className="row">
                <div className="col-lg-5">
                  <div className="contact-sec-left">
                    <h4>Questions ?</h4>
                    <h3>Just let us know !</h3>

                    <p className="para">
                      Get in touch with Credit Services USA today — our experts
                      are ready to guide you toward better credit and a stronger
                      financial future.
                    </p>

                    <ul className="contact-info">
                      <li>
                        <Link href={"mailto:dgabbott@outloo.com"}>
                          <IoMdMail /> dgabbott@outloo.com
                        </Link>
                      </li>
                      <li>
                        <Link href={"tel:609-467-9377"}>
                          <FaPhoneAlt /> 609-467-9377
                        </Link>
                      </li>
                      <li>
                        <Link href={"#"}>
                          <IoLocationSharp /> Your Location
                        </Link>
                      </li>
                    </ul>
                    <ul className="contact-social">
                      <li>
                        <Link href={"/"}>
                          <FaFacebookF size={20} />
                        </Link>
                      </li>
                      <li>
                        <Link href={"/"}>
                          <FaInstagram size={20} />
                        </Link>
                      </li>
                      <li>
                        <Link href={"/"}>
                          <FaXTwitter size={20} />
                        </Link>
                      </li>
                    </ul>
                  </div>
                </div>
                <div className="col-lg-7">
                  <div className="contact-form-right">
                    <h2>
                      Connect with Us <br /> Today!
                    </h2>
                    <form onSubmit={handleSubmit}>
                      <div className="row">
                        <div className="col-lg-12">
                          <input
                            type="text"
                            name="name"
                            value={formData.name}
                            onChange={handleChange}
                            placeholder="Your Name"
                          />
                        </div>
                        <div className="col-lg-12">
                          <input
                            type="email"
                            placeholder="Your Email"
                            name="email"
                            value={formData.email}
                            onChange={handleChange}
                          />
                        </div>
                        <div className="col-lg-12">
                          <input
                            type="number"
                            placeholder="Your Phone Number"
                            name="phone"
                            value={formData.phone}
                            onChange={handleChange}
                          />
                        </div>
                        <div className="col-lg-12">
                          <textarea
                            placeholder="Your Message"
                            name="message"
                            value={formData.message}
                            onChange={handleChange}
                          ></textarea>
                        </div>
                        <div className="col-lg-12">
                          <button type="submit" disabled={loading}>
                            {loading ? "Sending..." : "Send"}{" "}
                            <GoArrowUpRight color="#fff" size={20} />
                          </button>
                        </div>
                      </div>
                    </form>
                    {feedback && (
                      <p
                        style={{
                          color: feedback.success ? "green" : "red",
                          marginTop: "10px",
                        }}
                      >
                        {feedback.message}
                      </p>
                    )}
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default HomePageContactSec;
