import React from "react";
import "./HomePageBanner.css";
import Link from "next/link";
import { FaArrowRight } from "react-icons/fa";
import Image from "next/image";
import client1 from "../../../public/images/client1.png";
import client2 from "../../../public/images/client2.png";
import client3 from "../../../public/images/client3.png";
import homeBannerRight from "../../../public/images/home-banner-right.png";

const HomePageBanner = () => {
  return (
    <section className="home-banner">
      <div className="container-fluid">
        <div className="row">
          <div className="col-lg-12">
            <div className="home-banner-content-main">
              <div className="row align-items-center">
                <div className="col-lg-6" style={{ paddingLeft: 0 }}>
                  <div className="home-banner-content">
                    <h1>
                      Take Control of Your Credit. Take Control of Your Future.
                    </h1>
                    <p>
                      At Credit Services USA, LLC we specialize in credit report
                      correction, financial consultation, and personalized
                      strategies to help you achieve the financial freedom you
                      deserve.
                    </p>

                    <div className="home-banner-btns">
                      <Link href="/contact-us" className="btn-1">
                        Get Started Today
                      </Link>
                      <Link href="/contact-us" className="btn-2">
                        Schedule Your Free Consultation{" "}
                        <FaArrowRight color="#7b011d" />
                      </Link>
                    </div>

                    <div className="trusted-clients">
                      <p>TRUSTED BY CLIENTS FROM WORLDWIDE</p>
                      <div className="trusted-clientsImage">
                        <Image
                          src={client1}
                          alt="client1"
                          width={77}
                          height={76}
                        />
                        <Image
                          src={client2}
                          alt="client1"
                          width={77}
                          height={76}
                        />
                        <Image
                          src={client3}
                          alt="client1"
                          width={77}
                          height={76}
                        />
                        <span>1K+</span>
                      </div>
                    </div>
                  </div>
                </div>
                <div className="col-lg-6">
                  <div className="banner-right-image">
                    <Image
                      src={homeBannerRight}
                      width={904}
                      height={826}
                      alt="homeBannerRight"
                    />
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default HomePageBanner;
