import React from "react";
import "./HomePageAbout.css";
import Link from "next/link";
import { FaArrowRight } from "react-icons/fa";
import Image from "next/image";
import homeAboutImage from "../../../public/images/home-about-image.png";

const HomePageAbout = () => {
  return (
    <section className="HomePageAbout">
      <div className="container-fluid">
        <div className="row">
          <div className="col-lg-12">
            <div className="home-page-about-main-content">
              <div className="row align-items-center">
                <div className="col-lg-6">
                  <div className="HomePageAbout-content-left">
                    <h3>About Us</h3>
                    <h2>
                      <span>Restoring</span> Credit. <span>Restoring</span>{" "}
                      Confidence
                    </h2>

                    <div className="HomePageAbout-content-left2">
                      <h3>Our Mission</h3>
                      <p className="para">
                        At Credit Services USA, LLC our mission is to empower
                        individuals and businesses to take control of their
                        financial future. We are committed to delivering
                        reliable credit report correction, expert financial
                        consultation, and personalized strategies that restore
                        confidence, build trust, and open doors to new
                        opportunities.
                      </p>
                    </div>

                    <div className="home-about-marginT">
                      <Link href={"/contact-us"} className="button-class">
                        Schedule Your Free Consultation{" "}
                        <FaArrowRight color="#fff" />
                      </Link>
                    </div>
                  </div>
                </div>
                <div className="col-lg-6">
                  <div className="home-about-content-right">
                    <p className="para">
                      Credit Services USA, LLC is a trusted financial
                      consultation firm dedicated to improving credit health for
                      individuals and businesses. With years of industry
                      expertise, we’ve helped countless clients correct
                      inaccuracies on their credit reports, restore confidence,
                      and unlock new financial opportunities. Our mission is
                      simple—deliver clear, effective, and ethical credit
                      solutions tailored to your needs.
                    </p>
                    <Image
                      src={homeAboutImage}
                      height={389}
                      width={887}
                      alt="home-about-image"
                    />
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default HomePageAbout;
