"use client";
import React from "react";
import "./Header.css";
import Link from "next/link";
import Image from "next/image";
import { usePathname } from "next/navigation";
import { FaArrowRight } from "react-icons/fa";

import LOGO_IMG from "../../../public/images/logo.png";

const Header = () => {
  const pathname = usePathname(); 
  return (
    <header className="header">
      <div className="container-fluid">
        <div className="row">
          <div className="col-lg-12">
            <nav className="navbar navbar-expand-lg navbar-light">
              <div className="container-fluid">
                <Link className="navbar-brand" href="/">
                  <Image src={LOGO_IMG} width={190} height={74} alt="logo" />
                </Link>
                <button
                  className="navbar-toggler"
                  type="button"
                  data-bs-toggle="collapse"
                  data-bs-target="#navbarSupportedContent"
                  aria-controls="navbarSupportedContent"
                  aria-expanded="false"
                  aria-label="Toggle navigation"
                >
                  <span className="navbar-toggler-icon"></span>
                </button>
                <div
                  className="collapse navbar-collapse"
                  id="navbarSupportedContent"
                >
                  <ul className="navbar-nav m-auto">
                    <li className="nav-item">
                      <Link
                        className={`nav-link ${
                          pathname === "/" ? "active" : ""
                        }`}
                        href="/"
                      >
                        Home
                      </Link>
                    </li>
                    <li className="nav-item">
                      <Link
                        className={`nav-link ${
                          pathname === "/about-us" ? "active" : ""
                        }`}
                        href="/about-us"
                      >
                        About
                      </Link>
                    </li>
                    <li className="nav-item">
                      <Link
                        className={`nav-link ${
                          pathname === "/services" ? "active" : ""
                        }`}
                        href="/services"
                      >
                        Services
                      </Link>
                    </li>
                    <li className="nav-item">
                      <Link
                        className={`nav-link ${
                          pathname === "/faq" ? "active" : ""
                        }`}
                        href="/faq"
                      >
                        FAQ
                      </Link>
                    </li>
                    <li className="nav-item">
                      <Link
                        className={`nav-link ${
                          pathname === "/contact-us" ? "active" : ""
                        }`}
                        href="/contact-us"
                      >
                        Contact
                      </Link>
                    </li>
                  </ul>
                  <div className="header-right-btn">
                    <Link href="/contact-us">
                      Schedule Your Free Consultation <FaArrowRight />
                    </Link>
                  </div>
                </div>
              </div>
            </nav>
          </div>
        </div>
      </div>
    </header>
  );
};

export default Header;
