import React from "react";
import "./Footer.css";
import footer_logo from "../../../public/images/footer-logo.png";
import Image from "next/image";
import Link from "next/link";
import { IoLogoGoogle } from "react-icons/io";
import { FaFacebook, FaLinkedinIn, FaTwitter } from "react-icons/fa";
import { IoChevronForward } from "react-icons/io5";
import CopyRight from "../../../public/images/copy-right.png";

const Footer = () => {
  return (
    <footer className="footer">
      <div className="container">
        <div className="row">
          <div className="col-lg-12">
            <div className="footer-cta">
              <div className="footer-cta-content">
                <h3 className="same-heading">
                  Ready to Fix Your Credit? <span>Let’s Start Today.</span>
                </h3>
                <Link href={"/contact-us"}>Call Now</Link>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div className="container-fluid">
        <div className="row">
          <div className="col-lg-12">
            <div className="footer-main-div">
              <div className="row">
                <div className="col-lg-4">
                  <div className="footer-left-intro">
                    <Link href={"/"}>
                      <Image
                        src={footer_logo}
                        width={254}
                        height={103}
                        alt="footer_logo"
                      />
                    </Link>

                    <p className="para">
                      Lorem ipsum dolor sit amet, consectetuer adipiscing elit.
                      Aenean commodo ligula eget dolor. Aenean massa.
                    </p>

                    <ul>
                      <li>
                        <Link href={"#"}>
                          <IoLogoGoogle size={20} color="#fff" />
                        </Link>
                      </li>
                      <li>
                        <Link href={"#"}>
                          <FaFacebook size={20} color="#fff" />
                        </Link>
                      </li>
                      <li>
                        <Link href={"#"}>
                          <FaTwitter size={20} color="#fff" />
                        </Link>
                      </li>
                      <li>
                        <Link href={"#"}>
                          <FaLinkedinIn size={20} color="#fff" />
                        </Link>
                      </li>
                    </ul>
                  </div>
                </div>
                <div className="col-lg-8">
                  <div className="footer-links">
                    <div className="row">
                      <div className="col-lg-4">
                        <h4>Useful Links</h4>
                        <ul>
                          <li>
                            <Link href={"/about-us"}>
                              <IoChevronForward color="#e8e8e8" /> About Us
                            </Link>
                          </li>
                          <li>
                            <Link href={"/services"}>
                              <IoChevronForward color="#e8e8e8" /> Services
                            </Link>
                          </li>
                          <li>
                            <Link href={"/faq"}>
                              <IoChevronForward color="#e8e8e8" /> FAQ
                            </Link>
                          </li>
                        </ul>
                      </div>
                      <div className="col-lg-4">
                        <h4>Services</h4>
                        <ul>
                          <li>
                            <Link href={"/services"}>
                              <IoChevronForward color="#e8e8e8" /> Credit Report
                              Correction
                            </Link>
                          </li>
                          <li>
                            <Link href={"/services"}>
                              <IoChevronForward color="#e8e8e8" /> Credit
                              Consultation
                            </Link>
                          </li>
                          <li>
                            <Link href={"/services"}>
                              <IoChevronForward color="#e8e8e8" /> Debt &
                              Financial Guidance
                            </Link>
                          </li>
                          <li>
                            <Link href={"/services"}>
                              <IoChevronForward color="#e8e8e8" /> Credit
                              Monitoring Support
                            </Link>
                          </li>
                        </ul>
                      </div>
                      <div className="col-lg-4">
                        <h4>Contact Us</h4>
                        <ul>
                          <li>Address : Your Location</li>
                          <li>
                            Call Us :{" "}
                            <Link href={"tel:6094679377"}>609-467-9377</Link>
                          </li>
                          <li>
                            Mail:{" "}
                            <Link href={"mailto:dgabbott@outloo.com"}>
                              dgabbott@outloo.com
                            </Link>
                          </li>
                        </ul>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div className="col-lg-6">
            <div className="copy-right">
              <p className="para">
                <Image src={CopyRight} width={30} height={30} alt="CopyRight" />{" "}
                All Rights Reserved 2025 - Credit Services USA, LLC . Powered by
                <Link href={"https://hadztech.com/"} target="_blank">
                  Hadztech
                </Link>
              </p>
            </div>
          </div>
          <div className="col-lg-6">
            <div className="copy-right d-flex justify-content-center">
                <Link href={"/terms-and-conditions"}>
                  Terms & Conditions
                </Link>
            </div>
          </div>
        </div>
      </div>
    </footer>
  );
};

export default Footer;
