"use client"
import React, { useState } from 'react';
import "./FaqSec.css";

const FAQItem = ({ question, answer, isOpen, onToggle }) => {
  return (
    <div className={`faq-item ${isOpen ? 'faq-item-open' : 'faq-item-closed'}`}>
      <button
        onClick={onToggle}
        className="faq-question-btn"
      >
        <div className="faq-icon-container">
          <div className={`faq-toggle-icon ${isOpen ? 'faq-toggle-open' : 'faq-toggle-closed'}`}>
            {isOpen ? '−' : '+'}
          </div>
        </div>
        <h3 className={`faq-question ${isOpen ? 'faq-question-active' : 'faq-question-inactive'}`}>
          {question}
        </h3>
      </button>
      {isOpen && answer && (
        <div className="faq-answer-container">
          <div className="row">
            <div className="col-xl-10 col-lg-11 col-md-12 offset-xl-1">
              <p className="faq-answer-text">
                {answer}
              </p>
            </div>
          </div>
        </div>
      )}
    </div>
  );
};

const FAQSection = () => {
  const [openIndex, setOpenIndex] = useState(1);

  const faqs = [
    {
      question: "What is a Ghostwriter?",
      answer: null
    },
    {
      question: "What the process of Ghostwriting includes?",
      answer: "In a standard ghostwriting package, you'll receive a draft and a review. As a ghostwriting service, we're pleased to customize our services to accommodate your personality, schedule, and publishing goals."
    },
    {
      question: "Will the Ghostwriters look after proofreading and editing?",
      answer: null
    },
    {
      question: "Can you design my novel's cover?",
      answer: null
    },
    {
      question: "What is the word count of a Ghostwriting Professional?",
      answer: null
    },
    {
      question: "What is the complete duration for completing a book?",
      answer: null
    }
  ];

  return (
    <>
      <section className="faq-section-main">
        <div className="container-fluid">
          <div className="row justify-content-center">
            <div className="col-12">
              {/* Header Section */}
              <div className="row justify-content-center">
                <div className="col-xl-12 col-lg-11 col-md-12">
                  <div className="faq-header text-center">
                    <h2 className="faq-title">
                      Frequently Asked <span className="faq-title-highlight">Questions</span>
                    </h2>
                    <p className="faq-subtitle">
                      Reach Out to Us for Further Assistance.
                    </p>
                  </div>
                </div>
              </div>

              {/* FAQ Items */}
              <div className="row justify-content-center">
                <div className="col-xl-12 col-lg-12 col-md-12">
                  <div className="faq-container">
                    {faqs.map((faq, index) => (
                      <FAQItem
                        key={index}
                        question={faq.question}
                        answer={faq.answer}
                        isOpen={openIndex === index}
                        onToggle={() => setOpenIndex(openIndex === index ? -1 : index)}
                      />
                    ))}
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
};

export default FAQSection;