import mongoose from "mongoose";

const contactSchema = new mongoose.Schema(
  {
    name: {
      type: String,
      required: [true, "Name is required"],
      trim: true,
      max_length: [50, "Name cannot exceed 50 characters"],
    },
    email: {
      type: String,
      required: [true, "Email is required"],
      trim: true,
      lowercase: true,
      match: [
        /^\w+([.-]?\w+)*@\w+([.-]?\w+)*(\.\w{2,3})+$/,
        "Please enter a valid email",
      ],
    },
    phone: {
        type: String,
        required: [true, "Phone is required"],
        trim: true,
        match: [
            /^\+?[1-9]\d{1,14}$/,
            "Please enter a valid phone number",
        ],
    },
    message: {
      type: String,
      required: [true, "Contact message is required"],
      max_length: [1000, "message cannot exceed 1000 characters"],
    },
  },
  {
    timestamps: true,
    toJSON: {
      transform: function (doc, ret) {
        ret.id = ret._id;
        delete ret._id;
        delete ret.__v;
        return ret;
      },
    },
  }
);

export default mongoose.models.Contact ||
  mongoose.model("Contact", contactSchema);
