"use client";
import React, { useState } from "react";
import "./ServicesBoxSec.css";
import Image from "next/image";
import service1 from "../../../public/images/service1.svg";
import service2 from "../../../public/images/service2.svg";
import service3 from "../../../public/images/service3.svg";
import service4 from "../../../public/images/service4.svg";
import ServiceFormModal from "../ServiceFormModal/ServiceFormModal";

const ServicesBoxSec = () => {
  const [show, setShow] = useState(false);
  const [selectedService, setSelectedService] = useState("");

  const openModal = (serviceName) => {
    setSelectedService(serviceName);
    setShow(true);
  };

  const closeModal = () => setShow(false);

  return (
    <section className="services-box-sec">
      <div className="container">
        <div className="row">
          <div className="col-lg-12 text-center">
            <h2 className="same-heading">
              Our <span>Services</span>
            </h2>
          </div>
        </div>
        <div className="row">
          {[
            {
              img: service1,
              title: "Credit Report Correction",
              para: `Identify and correct inaccurate details on your credit report with expert support that ensures your financial profile stays clear and trustworthy.`,
            },
            {
              img: service2,
              title: "Continuous Credit Monitoring",
              para: `Monitor your credit with real-time alerts and updates to keep your financial profile secure and accurate.`,
            },
            {
              img: service3,
              title: "Debt & Financial Guidance",
              para: "Get expert guidance and practical solutions to manage debt wisely and build lasting financial confidence.",
            },
            {
              img: service4,
              title: "Credit Report Monitoring",
              para: `This Monitoring Service ensures real-time tracking of corrective actions and provides updates on subsequent changes in the client’s Credit Score.`,
            },
          ].map((service, i) => (
            <div className="col-lg-3" key={i}>
              <div
                className="services-sec-box"
                onClick={() => openModal(service.title)}
              >
                <Image src={service.img} alt={service.title} />
                <h4>{service.title}</h4>
                <p className="para">{service.para}</p>
              </div>
            </div>
          ))}
        </div>
      </div>

      {/* Modal */}
      <ServiceFormModal
        show={show}
        handleClose={closeModal}
        selectedService={selectedService}
      />
    </section>
  );
};

export default ServicesBoxSec;

// import React from "react";
// import "./ServicesBoxSec.css";
// import Image from "next/image";
// import service1 from "../../../public/images/service1.svg";
// import Link from "next/link";
// import service2 from "../../../public/images/service2.svg";
// import service3 from "../../../public/images/service3.svg";
// import service4 from "../../../public/images/service4.svg";

// const ServicesBoxSec = () => {
//   return (
//     <section className="services-box-sec">
//       <div className="container">
//         <div className="row">
//           <div className="col-lg-12">
//             <div className="services-box-content">
//               <h2 className="same-heading text-center">
//                 Our <span>Services</span>
//               </h2>
//             </div>
//           </div>
//         </div>
//         <div className="row">
//           <div className="col-lg-3">
//             <Link href={"/"}>
//               <div className="services-sec-box">
//                 <Image src={service1} alt="services-box-image" />

//                 <h4>Credit Report Correction</h4>
//                 <p className="para">
//                   Ever Find Yourself Staring At Computer is Screen A Good that
//                   Consulting that
//                 </p>
//               </div>
//             </Link>
//           </div>
//           <div className="col-lg-3">
//             <Link href={"/"}>
//               <div className="services-sec-box">
//                 <Image src={service2} alt="services-box-image" />

//                 <h4>Credit Consultation</h4>
//                 <p className="para">
//                   Ever Find Yourself Staring At Computer is Screen A Good that
//                   Consulting that
//                 </p>
//               </div>
//             </Link>
//           </div>
//           <div className="col-lg-3">
//             <Link href={"/"}>
//               <div className="services-sec-box">
//                 <Image src={service3} alt="services-box-image" />

//                 <h4>Debt & Financial Guidance</h4>
//                 <p className="para">
//                   Ever Find Yourself Staring At Computer is Screen A Good that
//                   Consulting that
//                 </p>
//               </div>
//             </Link>
//           </div>
//           <div className="col-lg-3">
//             <Link href={"/"}>
//               <div className="services-sec-box">
//                 <Image src={service4} alt="services-box-image" />

//                 <h4>Credit Monitoring Support</h4>
//                 <p className="para">
//                   Ever Find Yourself Staring At Computer is Screen A Good that
//                   Consulting that
//                 </p>
//               </div>
//             </Link>
//           </div>
//         </div>
//       </div>
//     </section>
//   );
// };

// export default ServicesBoxSec;
