import React from "react";
import "./HomePageTrust.css";
import Link from "next/link";
import { FaArrowRight } from "react-icons/fa";

const HomePageTrust = () => {
  return (
    <section className="HomePageTrust">
      <div className="container-fluid">
        <div className="row">
          <div className="col-lg-12">
            <div className="HomePageTrust-content">
              <h2 className="same-heading">
                <span>Why Clients</span> Trust Credit <br /> Services{" "}
                <span>USA</span>
              </h2>
              <p className="para">
                Clients trust us for our proven results, transparent process,
                and unwavering dedication to restoring and protecting their
                financial confidence.
              </p>

              <div className="HomePageTrust-content-box-main">
                <div className="row">
                  <div className="col-lg-4">
                    <div className="HomePageTrust-content-box">
                      <span>01</span>
                      <div className="HomePageTrust-content-box-content">
                        <h4>Experienced Professionals</h4>
                        <p>Decades of combined financial expertise</p>
                      </div>
                      <div className="overlay">
                        <span>01</span>
                        <h3>Experienced Professionals</h3>
                        <p className="para">
                          Decades of combined financial expertise
                        </p>
                        <div className="d-flex mt-2">
                          <Link href="/services">
                            See More <FaArrowRight color="#7b011d" size={18} />
                          </Link>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div className="col-lg-4">
                    <div className="HomePageTrust-content-box">
                      <span>02</span>
                      <div className="HomePageTrust-content-box-content">
                        <h4>Transparent Process</h4>
                        <p>
                          Clear, ethical, and compliant with industry standards
                        </p>
                      </div>
                      <div className="overlay">
                        <span>02</span>
                        <h3>Transparent Process</h3>
                        <p className="para">
                          Clear, ethical, and compliant with industry standards
                        </p>
                        <div className="d-flex mt-2">
                          <Link href="/services">
                            See More <FaArrowRight color="#7b011d" size={18} />
                          </Link>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div className="col-lg-4">
                    <div className="HomePageTrust-content-box HomePageTrust-content-box3">
                      <span>03</span>
                      <div className="HomePageTrust-content-box-content">
                        <h4>Proven Results</h4>
                        <p>Successfully corrected hundreds of credit reports</p>
                      </div>
                      <div className="overlay">
                        <span>03</span>
                        <h3>Proven Results</h3>
                        <p className="para">
                          Successfully corrected hundreds of credit reports
                        </p>
                        <div className="d-flex mt-2">
                          <Link href="/services">
                            See More <FaArrowRight color="#7b011d" size={18} />
                          </Link>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default HomePageTrust;
