"use client";
import React from "react";
import "./HomePageClientReview.css";
import Image from "next/image";
import review1 from "../../../public/images/review1.png";
import review2 from "../../../public/images/review2.png";
import review3 from "../../../public/images/review3.png";
import review4 from "../../../public/images/review4.png";
import review5 from "../../../public/images/review5.png";
import { FaStar } from "react-icons/fa";
import { BiSolidQuoteAltRight } from "react-icons/bi";

import { Swiper, SwiperSlide } from "swiper/react";

// Import Swiper styles
import "swiper/css";
import "swiper/css/free-mode";
import { FreeMode, Autoplay } from "swiper/modules";

const HomePageClientReview = () => {
  return (
    <section className="HomePageClientReview">
      <div className="container-fluid">
        <div className="row">
          <div className="col-lg-12">
            <div className="HomePageClientReview-content">
              <h2 className="same-heading">
                <span>Client</span> Reviews
              </h2>
              <p className="para">
                Discover how Credit Services USA has helped clients regain
                control of their finances and achieve the credit confidence they
                deserve.
              </p>
            </div>
          </div>

          <div className="col-lg-12">
            <div className="client-review-main-box">
              <Swiper
                slidesPerView={4}
                spaceBetween={30}
                freeMode={true}
                loop={true}
                autoplay={{
                  delay: 2500,
                  disableOnInteraction: false,
                }}
                modules={[FreeMode, Autoplay]}
                className="mySwiper"
              >
                <SwiperSlide>
                  <div className="client-review-box">
                    <span>
                      <BiSolidQuoteAltRight color="#262626" size={30} />
                    </span>
                    <div className="client-review-box-content">
                      <Image
                        src={review1}
                        width={80}
                        height={80}
                        alt="review1"
                      />
                      <div className="client-review-details">
                        <h3>John Doe</h3>
                        <div className="review-star">
                          <FaStar color="#FFD029" size={18} />
                          <FaStar color="#FFD029" size={18} />
                          <FaStar color="#FFD029" size={18} />
                          <FaStar color="#FFD029" size={18} />
                          <FaStar color="#FFD029" size={18} />
                        </div>
                      </div>
                    </div>
                    <p className="para">
                      The intuitive design and smart features of Credit Services USA made it
                      easy to find meaningful connections. It's become my go-to
                      app.
                    </p>
                  </div>
                </SwiperSlide>
                <SwiperSlide>
                  <div className="client-review-box">
                    <span>
                      <BiSolidQuoteAltRight color="#262626" size={30} />
                    </span>
                    <div className="client-review-box-content">
                      <Image
                        src={review2}
                        width={80}
                        height={80}
                        alt="review1"
                      />
                      <div className="client-review-details">
                        <h3>Emily Johnson</h3>
                        <div className="review-star">
                          <FaStar color="#FFD029" size={18} />
                          <FaStar color="#FFD029" size={18} />
                          <FaStar color="#FFD029" size={18} />
                          <FaStar color="#FFD029" size={18} />
                          <FaStar color="#FFD029" size={18} />
                        </div>
                      </div>
                    </div>
                    <p className="para">
                      I’m amazed at how Credit Services USA’s advanced privacy controls and
                      customizable features have enhanced my online social
                      experience. Truly innovative.
                    </p>
                  </div>
                </SwiperSlide>
                <SwiperSlide>
                  <div className="client-review-box">
                    <span>
                      <BiSolidQuoteAltRight color="#262626" size={30} />
                    </span>
                    <div className="client-review-box-content">
                      <Image
                        src={review3}
                        width={80}
                        height={80}
                        alt="review1"
                      />
                      <div className="client-review-details">
                        <h3>Emily Johnson</h3>
                        <div className="review-star">
                          <FaStar color="#FFD029" size={18} />
                          <FaStar color="#FFD029" size={18} />
                          <FaStar color="#FFD029" size={18} />
                          <FaStar color="#FFD029" size={18} />
                          <FaStar color="#FFD029" size={18} />
                        </div>
                      </div>
                    </div>
                    <p className="para">
                      I love how Credit Services USA helps me stay in touch with friends and
                      meet new people. The app is user-friendly and effective.
                    </p>
                  </div>
                </SwiperSlide>
                <SwiperSlide>
                  <div className="client-review-box">
                    <span>
                      <BiSolidQuoteAltRight color="#262626" size={30} />
                    </span>
                    <div className="client-review-box-content">
                      <Image
                        src={review4}
                        width={80}
                        height={80}
                        alt="review1"
                      />
                      <div className="client-review-details">
                        <h3>Michael Brown</h3>
                        <div className="review-star">
                          <FaStar color="#FFD029" size={18} />
                          <FaStar color="#FFD029" size={18} />
                          <FaStar color="#FFD029" size={18} />
                          <FaStar color="#FFD029" size={18} />
                          <FaStar color="#FFD029" size={18} />
                        </div>
                      </div>
                    </div>
                    <p className="para">
                      With Credit Services USA, I've expanded my network and found genuine
                      connections. The seamless interface makes socializing so
                      much easier.
                    </p>
                  </div>
                </SwiperSlide>
                <SwiperSlide>
                  <div className="client-review-box">
                    <span>
                      <BiSolidQuoteAltRight color="#262626" size={30} />
                    </span>
                    <div className="client-review-box-content">
                      <Image
                        src={review5}
                        width={80}
                        height={80}
                        alt="review1"
                      />
                      <div className="client-review-details">
                        <h3>Laura Martinez</h3>
                        <div className="review-star">
                          <FaStar color="#FFD029" size={18} />
                          <FaStar color="#FFD029" size={18} />
                          <FaStar color="#FFD029" size={18} />
                          <FaStar color="#FFD029" size={18} />
                          <FaStar color="#FFD029" size={18} />
                        </div>
                      </div>
                    </div>
                    <p className="para">
                      I’m amazed at how Credit Services USA’s advanced privacy controls and
                      customizable features have enhanced my online social
                      experience. Truly innovative.
                    </p>
                  </div>
                </SwiperSlide>
              </Swiper>

              <div className="mt-4">
                <Swiper
                  slidesPerView={4}
                  spaceBetween={30}
                  freeMode={true}
                  autoplay={{
                    delay: 2500,
                    disableOnInteraction: false,
                    reverseDirection: true,
                  }}
                  loop={true}
                  modules={[FreeMode, Autoplay]}
                  className="mySwiper"
                >
                  <SwiperSlide>
                    <div className="client-review-box">
                      <span>
                        <BiSolidQuoteAltRight color="#262626" size={30} />
                      </span>
                      <div className="client-review-box-content">
                        <Image
                          src={review1}
                          width={80}
                          height={80}
                          alt="review1"
                        />
                        <div className="client-review-details">
                          <h3>John Doe</h3>
                          <div className="review-star">
                            <FaStar color="#FFD029" size={18} />
                            <FaStar color="#FFD029" size={18} />
                            <FaStar color="#FFD029" size={18} />
                            <FaStar color="#FFD029" size={18} />
                            <FaStar color="#FFD029" size={18} />
                          </div>
                        </div>
                      </div>
                      <p className="para">
                        The intuitive design and smart features of Credit Services USA made
                        it easy to find meaningful connections. It's become my
                        go-to app.
                      </p>
                    </div>
                  </SwiperSlide>
                  <SwiperSlide>
                    <div className="client-review-box">
                      <span>
                        <BiSolidQuoteAltRight color="#262626" size={30} />
                      </span>
                      <div className="client-review-box-content">
                        <Image
                          src={review2}
                          width={80}
                          height={80}
                          alt="review1"
                        />
                        <div className="client-review-details">
                          <h3>Emily Johnson</h3>
                          <div className="review-star">
                            <FaStar color="#FFD029" size={18} />
                            <FaStar color="#FFD029" size={18} />
                            <FaStar color="#FFD029" size={18} />
                            <FaStar color="#FFD029" size={18} />
                            <FaStar color="#FFD029" size={18} />
                          </div>
                        </div>
                      </div>
                      <p className="para">
                        I’m amazed at how Credit Services USA’s advanced privacy controls
                        and customizable features have enhanced my online social
                        experience. Truly innovative.
                      </p>
                    </div>
                  </SwiperSlide>
                  <SwiperSlide>
                    <div className="client-review-box">
                      <span>
                        <BiSolidQuoteAltRight color="#262626" size={30} />
                      </span>
                      <div className="client-review-box-content">
                        <Image
                          src={review3}
                          width={80}
                          height={80}
                          alt="review1"
                        />
                        <div className="client-review-details">
                          <h3>Emily Johnson</h3>
                          <div className="review-star">
                            <FaStar color="#FFD029" size={18} />
                            <FaStar color="#FFD029" size={18} />
                            <FaStar color="#FFD029" size={18} />
                            <FaStar color="#FFD029" size={18} />
                            <FaStar color="#FFD029" size={18} />
                          </div>
                        </div>
                      </div>
                      <p className="para">
                        I love how Credit Services USA helps me stay in touch with friends
                        and meet new people. The app is user-friendly and
                        effective.
                      </p>
                    </div>
                  </SwiperSlide>
                  <SwiperSlide>
                    <div className="client-review-box">
                      <span>
                        <BiSolidQuoteAltRight color="#262626" size={30} />
                      </span>
                      <div className="client-review-box-content">
                        <Image
                          src={review4}
                          width={80}
                          height={80}
                          alt="review1"
                        />
                        <div className="client-review-details">
                          <h3>Michael Brown</h3>
                          <div className="review-star">
                            <FaStar color="#FFD029" size={18} />
                            <FaStar color="#FFD029" size={18} />
                            <FaStar color="#FFD029" size={18} />
                            <FaStar color="#FFD029" size={18} />
                            <FaStar color="#FFD029" size={18} />
                          </div>
                        </div>
                      </div>
                      <p className="para">
                        With Credit Services USA, I've expanded my network and found genuine
                        connections. The seamless interface makes socializing so
                        much easier.
                      </p>
                    </div>
                  </SwiperSlide>
                  <SwiperSlide>
                    <div className="client-review-box">
                      <span>
                        <BiSolidQuoteAltRight color="#262626" size={30} />
                      </span>
                      <div className="client-review-box-content">
                        <Image
                          src={review5}
                          width={80}
                          height={80}
                          alt="review1"
                        />
                        <div className="client-review-details">
                          <h3>Laura Martinez</h3>
                          <div className="review-star">
                            <FaStar color="#FFD029" size={18} />
                            <FaStar color="#FFD029" size={18} />
                            <FaStar color="#FFD029" size={18} />
                            <FaStar color="#FFD029" size={18} />
                            <FaStar color="#FFD029" size={18} />
                          </div>
                        </div>
                      </div>
                      <p className="para">
                        I’m amazed at how Credit Services USA’s advanced privacy controls
                        and customizable features have enhanced my online social
                        experience. Truly innovative.
                      </p>
                    </div>
                  </SwiperSlide>
                </Swiper>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default HomePageClientReview;
