"use client";
import React from "react";
import "./HomePageBrands.css";
import Image from "next/image";
import { Swiper, SwiperSlide } from "swiper/react";

// Import Swiper styles
import "swiper/css";
import "swiper/css/pagination";

import Brand1 from "../../../public/images/brand1.png";
import Brand2 from "../../../public/images/brand2.png";
import Brand3 from "../../../public/images/brand3.png";
import Brand4 from "../../../public/images/brand4.png";
import Brand5 from "../../../public/images/brand5.png";
import Brand6 from "../../../public/images/brand6.png";

import { Autoplay } from "swiper/modules";

const HomePageBrands = () => {
  return (
    <section className="home-brand-sec">
      <div className="container">
        <div className="row">
          <div className="col-lg-12">
            <div className="home-brand-slider">
              <Swiper
                slidesPerView={6}
                spaceBetween={30}
                loop={true}
                pagination={{
                  clickable: true,
                }}
                autoplay={{
                  delay: 1500,
                  disableOnInteraction: false,
                }}
                modules={[Autoplay]}
                className="mySwiper"
              >
                <SwiperSlide>
                  <Image src={Brand1} width={172} height={58} alt="Brand1" />
                </SwiperSlide>
                <SwiperSlide>
                  <Image src={Brand2} width={172} height={58} alt="Brand2" />
                </SwiperSlide>
                <SwiperSlide>
                  <Image src={Brand3} width={172} height={58} alt="Brand3" />
                </SwiperSlide>
                <SwiperSlide>
                  <Image src={Brand4} width={172} height={58} alt="Brand4" />
                </SwiperSlide>
                <SwiperSlide>
                  <Image src={Brand5} width={172} height={58} alt="Brand5" />
                </SwiperSlide>
                <SwiperSlide>
                  <Image src={Brand6} width={172} height={58} alt="Brand6" />
                </SwiperSlide>
                <SwiperSlide>
                  <Image src={Brand1} width={172} height={58} alt="Brand1" />
                </SwiperSlide>
                <SwiperSlide>
                  <Image src={Brand2} width={172} height={58} alt="Brand2" />
                </SwiperSlide>
                <SwiperSlide>
                  <Image src={Brand3} width={172} height={58} alt="Brand3" />
                </SwiperSlide>
                <SwiperSlide>
                  <Image src={Brand4} width={172} height={58} alt="Brand4" />
                </SwiperSlide>
                <SwiperSlide>
                  <Image src={Brand5} width={172} height={58} alt="Brand5" />
                </SwiperSlide>
                <SwiperSlide>
                  <Image src={Brand6} width={172} height={58} alt="Brand6" />
                </SwiperSlide>
              </Swiper>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default HomePageBrands;
