"use client";
import React, { useState } from "react";
import "./ContactSec.css";

import { FaLocationDot } from "react-icons/fa6";
import { RiContactsBookFill } from "react-icons/ri";
import Link from "next/link";
import { FaClock } from "react-icons/fa";
import { IoChevronForward } from "react-icons/io5";

const ContactSec = () => {
  const [formData, setFormData] = useState({
    name: "",
    email: "",
    phone: "",
    message: "",
    terms: false,
  });

  const [loading, setLoading] = useState(false);
  const [feedback, setFeedback] = useState(null);

  const handleChange = (e) => {
    const { name, value, type, checked } = e.target;
    setFormData({
      ...formData,
      [name]: type === "checkbox" ? checked : value,
    });
  };

  const handleSubmit = async (e) => {
    e.preventDefault();

    if (!formData.terms) {
      setFeedback({ success: false, message: "You must agree to the terms." });
      return;
    }

    setLoading(true);
    setFeedback(null);

    try {
      const res = await fetch("/api/contact-us", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify(formData),
      });

      const data = await res.json();

      if (res.ok) {
        setFeedback({ success: true, message: data.message });
        setFormData({
          name: "",
          email: "",
          phone: "",
          message: "",
          terms: false,
        });
      } else {
        setFeedback({
          success: false,
          message: data.error || "Something went wrong",
        });
      }
    } catch (err) {
      setFeedback({
        success: false,
        message: "Failed to submit. Try again later.",
      });
    } finally {
      setLoading(false);
    }
  };
  return (
    <section className="contact-sec">
      <div className="container">
        <div className="row align-items-center">
          <div className="col-lg-5">
            <div className="contact-sec-left">
              <iframe
                src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2796.6603484124284!2d-73.71924982344011!3d45.49678403126355!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x4cc93d557ca9df1d%3A0x2856575cf57f9ede!2s1655%20Rue%20B%C3%A9gin%2C%20Saint-Laurent%2C%20QC%20H4R%201W9%2C%20Canada!5e0!3m2!1sen!2s!4v1758750015472!5m2!1sen!2s"
                style={{ border: "0", width: "100%", height: "450px" }}
                allowFullScreen=""
                loading="lazy"
                referrerPolicy="no-referrer-when-downgrade"
              ></iframe>

              <div className="contact-sec-left-details">
                <div className="contact-sec-left-detailsBox">
                  <div className="details-box">
                    <div className="details-box-svg-bg">
                      <FaLocationDot size={20} color="#fff" />
                    </div>
                    <div className="details-box-content">
                      <h5>Address</h5>
                      <p>Your Location</p>
                    </div>
                  </div>
                  <div className="details-box">
                    <div className="details-box-svg-bg">
                      <RiContactsBookFill size={20} color="#fff" />
                    </div>
                    <div className="details-box-content">
                      <h5>Contact Us</h5>
                      <Link href="mailto:dgabbott@outloo.com">
                        dgabbott@outloo.com
                      </Link>
                      <br />
                      <Link href="tel:6094679377">
                        Call Us 24/7: 609-467-9377
                      </Link>
                    </div>
                  </div>
                  {/* <div className="details-box">
                    <div className="details-box-svg-bg">
                      <FaClock size={20} color="#fff" />
                    </div>
                    <div className="details-box-content">
                      <h5>Working Hours</h5>
                      <p>Mon - Fri: 8 AM - 6:30 PM</p>
                      <p>Sat: 9.00am - 17.00pm Holidays: Closes</p>
                    </div>
                  </div> */}
                </div>
              </div>
            </div>
          </div>
          <div className="col-lg-7">
            <div className="contact-sec-right">
              <h3>Let's Cooperate Together</h3>
              <h2>Contact Us Today!</h2>
              <p className="para">
                We will reply you within 24 hours via email, thank you <br />{" "}
                for contacting
              </p>

              <form onSubmit={handleSubmit}>
                <div className="row align-items-center">
                  <div className="col-lg-6">
                    <input
                      type="text"
                      name="name"
                      placeholder="Name*"
                      value={formData.name}
                      onChange={handleChange}
                      required
                    />
                  </div>
                  <div className="col-lg-6">
                    <input
                      type="email"
                      name="email"
                      placeholder="Email*"
                      value={formData.email}
                      onChange={handleChange}
                      required
                    />
                  </div>
                  <div className="col-lg-12">
                    <input
                      type="number"
                      name="phone"
                      placeholder="Phone*"
                      value={formData.phone}
                      onChange={handleChange}
                      required
                    />
                  </div>
                  <div className="col-lg-12">
                    <textarea
                      name="message"
                      placeholder="Message..."
                      value={formData.message}
                      onChange={handleChange}
                      required
                    />
                  </div>
                  <div className="col-lg-6">
                    <label>
                      <input
                        type="checkbox"
                        name="terms"
                        checked={formData.terms}
                        onChange={handleChange}
                      />
                      <span>Agree to our terms and conditions</span>
                    </label>
                  </div>
                  <div className="col-lg-6">
                    <div className="welcome-anchor">
                      <button
                        type="submit"
                        className="global-anchor-green"
                        disabled={loading}
                      >
                        {loading ? "Sending..." : "Send Message"}{" "}
                      </button>
                    </div>
                  </div>
                </div>
              </form>
              {feedback && (
                <p
                  style={{
                    color: feedback.success ? "green" : "red",
                    marginTop: "10px",
                  }}
                >
                  {feedback.message}
                </p>
              )}
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default ContactSec;
